/* console_bitmap_cls.c
   This method clears the screen image table, either by initializing all values to 0 or to an incrementing value.
   change log:
   12/24/2024 initial version
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <console.h>
#include <cache_private.h>

void console_bitmap_cls (int fill_pattern) {

   // initialize the screen image table by writing three sequences of 0..255
   unsigned char c     = 0;
   unsigned char c_inc = fill_pattern;

   VDP_SET_ADDRESS_WRITE (cachex.console.vdp_screen_image_table);
   for (int i = 0; i < 256 * CONSOLE_BITMAP_REGIONS; i++) {
      VDPWD  = c;
      c     += c_inc;
   }
}
