/* console_bitmap_draw_line.c
   This method draws a line between two points. As it is general purpose, it will naturally be slower than using the horizontal
   and vertical methods when those cases are appropriate.
   change log:
   12/24/2024 initial version
*/

#include <console.h>
#include <stdlib.h>

void plotLineLow (int y0, int x0, int y1, int x1, int mode) {
   int dx = x1 - x0;
   int dy = y1 - y0;
   int yi = 1;
   if (dy < 0) {
      yi = -1;
      dy = -dy;
   }
   int d = 2*dy - dx;
   int y = y0;

   for (int x = x0; x <= x1; x++) {
      console_bitmap_draw_pixel (y, x, mode);
      if (d > 0) {
         y = y + yi;
         d = d - 2 * dx;
      }
      d = d + 2 * dy;
   }
}

void plotLineHigh (int y0, int x0, int y1, int x1, int mode) {
   int dx = x1 - x0;
   int dy = y1 - y0;
   int xi = 1;
   if (dx < 0) {
      xi = -1;
      dx = -dx;
   }
   int d = 2 * dx - dy;
   int x = x0;

   for (int y = y0; y <= y1; y++) {
      console_bitmap_draw_pixel (y, x, mode);
      if (d > 0) {
         x = x + xi;
         d = d - 2 * dy;
      }
      d = d + 2 * dx;
   }
}

void console_bitmap_draw_line (int y0, int x0, int y1, int x1, int mode) {
    if (abs(y1 - y0) < abs(x1 - x0)) {
        if (x0 > x1) {
          plotLineLow (y1, x1, y0, x0, mode);
        } else {
          plotLineLow (y0, x0, y1, x1, mode);
        }
    } else {
        if (y0 > y1) {
          plotLineHigh (y1, x1, y0, x0, mode);
        } else {
          plotLineHigh (y0, x0, y1, x1, mode);
        }
    }
}
