/* console_bitmap_draw_line_down.c
   This method draws a line vertically downward from the origin.
   change log:
   12/24/2024 initial version
   01/13/2025 updated to minimize address calculations
              removed mode parameter
*/

#include <console.h>
#include <vdp.h>

void console_bitmap_draw_line_down (int y, int x, int len) {
   unsigned int row              = y >> 3;
   unsigned int row_offset       = y - (row << 3);
   const unsigned int col        = x >> 3;
   const unsigned int col_offset = x - (col << 3);
   unsigned int addr             = (((row << 5) + col) << 3) + row_offset;
   unsigned char c;

   while (len) {
      VDP_SET_ADDRESS (addr);
      c = VDPRD;
      c = c | (0x01 << ( 7 - col_offset));
      VDP_SET_ADDRESS_WRITE (addr);
      VDPWD = c;

      row_offset++;
      if (row_offset == 8) {
         row_offset = 0;
         addr += 256 - 7;
      } else {
         addr++;
      }
      len--;
   }
}
