/* console_bitmap_set_char.c
   This method sets the character id in the screen image table.
   change log:
   12/24/2024 initial version
   01/22/2025 performance improvements
*/

#include <console.h>
#include <vdp.h>
#include <cache_private.h>

void console_bitmap_set_char (int region, int y, int x, int id) {
   VDP_SET_ADDRESS_WRITE (cachex.console.vdp_screen_image_table + (region << 8) + (y << 5) + x);
   VDPWD = (unsigned char) id;
}
