/* console_bitmap_set_color_pattern.c
   This method sets the color pattern for a color block
   change log:
   12/24/2024 initial version
   01/11/2025 updated name to console_bitmap_set_color_pattern
   01/22/2025 performance improvements
*/

#include <console.h>
#include <cache_private.h>
#include <vdp.h>

void console_bitmap_set_color_pattern (int region, int id, unsigned char *pattern) {
   // initialize the color table to white on black
   vdpmemcpy (cachex.console.vdp_color_table + (((region << 8) + id) << 3), pattern, 8);
}
