/* console_bitmap_set_pattern.c
   This method sets a bitmap pattern for a block.
   change log:
   12/24/2024 initial version
   01/22/2025 performance improvements
*/

#include <console.h>
#include <cache_private.h>
#include <vdp.h>

void console_bitmap_set_pattern (int region, int id, unsigned char *pattern) {
   // initialize the character pattern table to all blanks
   vdpmemcpy (cachex.console.vdp_character_pattern_table + (((region << 8) + id) << 3), pattern, 8);
}
