// console_bitmap_set_pixel_and_color.c

#include <console.h>
#include <dylib.h>
#include <cache_private.h>
#include <vdp.h>

void console_bitmap_set_pixel_and_color (int y, int x, int mode, unsigned char color) {

   const unsigned int row         = y >> 3;            
   const unsigned int row_offset  = y - (row << 3);    
   const unsigned int col         = x >> 3;
   const unsigned int col_offset  = x - (col << 3);
   const unsigned int addr_offset = (((row << 5) + col) << 3) + row_offset;
 
   unsigned int addr;

   addr = cachex.console.vdp_character_pattern_table + addr_offset;
   
   unsigned char c;

   VDP_SET_ADDRESS (addr);
   c = VDPRD;
   if (mode) {
      c = c | (0x01 << ( 7 - col_offset));
   } else {
      c = c & (~ (0x01 << ( 7 - col_offset)));
   }
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = c;

   addr = cachex.console.vdp_color_table + addr_offset;
   
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = color;
}

