/* console_bitmap_set_pixel_color.c
   This method draws a single pixel.
   change log:
   12/24/2024 initial version
   01/22/2025 performance improvements
*/

#include <console.h>
#include <dylib.h>
#include <cache_private.h>
#include <vdp.h>

void console_bitmap_set_pixel_color (int y, int x, unsigned char color) {

   const unsigned int row         = y >> 3;
   const unsigned int row_offset  = y - (row << 3);
   const unsigned int col         = x >> 3;
   const unsigned int addr_offset = (((row << 5) + col) << 3) + row_offset;

   unsigned int addr = cachex.console.vdp_color_table + addr_offset;

   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = color;
}
