#include <console.h>
#include <vdp.h>
#include <dylib.h>
#include <cache_private.h>

const unsigned char font_bitmap[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 
   0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x28, 0x28, 0x7C, 0x28, 0x7C, 0x28, 0x28, 0x00, 
   0x38, 0x54, 0x50, 0x38, 0x14, 0x54, 0x38, 0x00, 
   0x60, 0x64, 0x08, 0x10, 0x20, 0x4C, 0x0C, 0x00, 
   0x20, 0x50, 0x50, 0x20, 0x54, 0x48, 0x34, 0x00, 
   0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x08, 0x10, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 
   0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 
   0x00, 0x28, 0x10, 0x7C, 0x10, 0x28, 0x00, 0x00, 
   0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x20, 
   0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 
   0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 
   0x38, 0x44, 0x4C, 0x54, 0x64, 0x44, 0x38, 0x00, 
   0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
   0x38, 0x44, 0x04, 0x08, 0x10, 0x20, 0x7C, 0x00, 
   0x38, 0x44, 0x04, 0x18, 0x04, 0x44, 0x38, 0x00, 
   0x08, 0x18, 0x28, 0x48, 0x7C, 0x08, 0x08, 0x00, 
   0x7C, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38, 0x00, 
   0x18, 0x20, 0x40, 0x78, 0x44, 0x44, 0x38, 0x00, 
   0x7C, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x00, 
   0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x38, 0x00, 
   0x38, 0x44, 0x44, 0x3C, 0x04, 0x08, 0x30, 0x00, 
   0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 
   0x00, 0x30, 0x30, 0x00, 0x30, 0x10, 0x20, 0x00, 
   0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 
   0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, 0x00, 
   0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 
   0x38, 0x44, 0x04, 0x08, 0x10, 0x00, 0x10, 0x00, 
   0x38, 0x44, 0x5C, 0x54, 0x5C, 0x40, 0x38, 0x00, 
   0x38, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, 
   0x78, 0x24, 0x24, 0x38, 0x24, 0x24, 0x78, 0x00, 
   0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00, 
   0x78, 0x24, 0x24, 0x24, 0x24, 0x24, 0x78, 0x00, 
   0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7C, 0x00, 
   0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 
   0x3C, 0x40, 0x40, 0x5C, 0x44, 0x44, 0x38, 0x00, 
   0x44, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, 
   0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
   0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 
   0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x00, 
   0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C, 0x00, 
   0x44, 0x6C, 0x54, 0x54, 0x44, 0x44, 0x44, 0x00, 
   0x44, 0x64, 0x64, 0x54, 0x4C, 0x4C, 0x44, 0x00, 
   0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 
   0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00, 
   0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34, 0x00, 
   0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x00, 
   0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x38, 0x00, 
   0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 
   0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 
   0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 
   0x44, 0x44, 0x44, 0x54, 0x54, 0x54, 0x28, 0x00, 
   0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0x00, 
   0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 
   0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C, 0x00, 
   0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00, 
   0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 
   0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 
   0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 
   0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x38, 0x04, 0x3C, 0x44, 0x3C, 0x00, 
   0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78, 0x00, 
   0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0x38, 0x00, 
   0x04, 0x04, 0x3C, 0x44, 0x44, 0x44, 0x3C, 0x00, 
   0x00, 0x00, 0x38, 0x44, 0x7C, 0x40, 0x38, 0x00, 
   0x0C, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 
   0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x38, 
   0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x44, 0x00, 
   0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
   0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 
   0x40, 0x40, 0x44, 0x48, 0x70, 0x48, 0x44, 0x00, 
   0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
   0x00, 0x00, 0x68, 0x54, 0x54, 0x54, 0x54, 0x00, 
   0x00, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00, 
   0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 
   0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x78, 0x40, 
   0x00, 0x00, 0x3C, 0x44, 0x44, 0x44, 0x3C, 0x04, 
   0x00, 0x00, 0x28, 0x34, 0x20, 0x20, 0x20, 0x00, 
   0x00, 0x00, 0x3C, 0x40, 0x38, 0x04, 0x78, 0x00, 
   0x00, 0x10, 0x38, 0x10, 0x10, 0x10, 0x0C, 0x00, 
   0x00, 0x00, 0x44, 0x44, 0x44, 0x4C, 0x34, 0x00, 
   0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00, 
   0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x28, 0x00, 
   0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 
   0x00, 0x00, 0x44, 0x44, 0x44, 0x3C, 0x04, 0x38, 
   0x00, 0x00, 0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00, 
   0x00, 0x0C, 0x10, 0x10, 0x20, 0x10, 0x10, 0x0C, 
   0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 
   0x00, 0x60, 0x10, 0x10, 0x08, 0x10, 0x10, 0x60, 
   0x00, 0x00, 0x20, 0x54, 0x08, 0x00, 0x00, 0x00
};

void console_bitmap_write_text_raw (int y, int x, const char *s) {
   unsigned int addr = cachex.console.vdp_character_pattern_table + (y << 8) + (x << 3);
   while (*s != 0x00) {
      if (*s >= ' ' && *s <= '~') {
         vdpmemcpy (addr, &font_bitmap[(*s - 32) << 3], 8);
         addr += 8;
      }
      s++;
   }
}
