/* console_border_color_get.c
   This method gets the color of the screen border.
   change log:
   10/20/2025 initial version
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_border_color_get () {
   int r;
   // switch by mode and ensure the call is valid
   switch (cachex.console.mode) {
      case DISPLAY_MODE_STANDARD:
      case DISPLAY_MODE_TEXT:
      case DISPLAY_MODE_F18A_TEXT80:
         r = cachex.console.vdp_screen_color & 0x0f;
         break;
      default:
         r = 0;
         break;
   }
   return r;
}
