/* console_border_color_set.c
   This method sets the color of the screen border.
   change log:
   06/01/2023 initial version
   08/24/2023 updated to use vdp_screen_color in cache
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_border_color_set (unsigned int x) {
   int r;
   // switch by mode and ensure the call is valid
   switch (cachex.console.mode) {
      case DISPLAY_MODE_STANDARD:
      case DISPLAY_MODE_TEXT:
         // set the border color, retaining the character color (only valid in text mode)
         cachex.console.vdp_screen_color = (cachex.console.vdp_screen_color & 0xf0) | (x & 0x0f);
         // set the color
         console_text_draw_color ();
         r = 0;
         break;
      default:
         r = -1;
         break;
   }
   return r;
}
