/* console_cache_init.c
   This sets the initialized cache values at system startup. Generally this method will only
   be called once, at the beginning of the system startup.
   change log:
   08/11/2023 initial version
   08/24/2023 added vdp_screen_color
   10/21/2023 removed all but the mode, which truly is the value that must be defined, and if it is, then all else is
   02/14/2024 updated to initialize the frame buffer / SIT values so the console methods can be reasonably used before complete 
              initialization
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
   02/10/2025 added question comments re initializing the frame index and setting the SIT
   02/11/2025 removed initialization of the frame index and sit address
*/

#include <constants.h>
#include <cache_private.h>
#include <console_private.h>
#include <vdp.h>

void console_cache_init () {
   cachex.console.mode = UNDEFINED;
}
