/* console_cls.c
   This method clears the screen.
   change log:
   06/01/2023 initial version
   10/21/2023 updated to clear the entire screen
   12/10/2023 changed reference to math
   02/06/2023 simplified to using vdpmemset and resetting console.vdp_text_addr_current
   02/16/2024 removed old disabled code
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
   02/11/2025 modified to clear the screen via GPU method if available
   02/13/2025 integration updates for GPU method calling
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <string.h>
#include <math.h>
#include <vdp.h>
#include <dylib.h>

void console_cls () {
   int r = gpu_execute (GPU_CLS);
   if (r) {
      vdpmemset (cachex.console.vdp_screen_image_table, 32, cachex.console.screen_height * cachex.console.screen_width);
   }
   cachex.console.vdp_text_addr_current = cachex.console.vdp_screen_image_table;    // reset to the top of the screen
}
