/* console_display_set_mode_legacy_parameters.c
   This method resets VDP parameters to those compatible with legacy TI products, including the TI home screen.

   change history
   02/13/2025 initial version
   10/09/2025 full reset of the F18A to power-on resets, so the TI boot screen can display correctly
*/

#include <console.h>
#include <console_private.h>
#include <vdp.h>
#include <cache_private.h>

void console_display_set_mode_legacy_parameters () {

   if (cache.gpu_method.gpu_is_present) {         

      VDP_SET_REGISTER (0x31, 0x00);           // reset rows to 24
      VDP_SET_REGISTER (0x32, 0x80);           // reset all F18A VDP registers to power-on defaults
      VDP_SET_REGISTER (0x39, 0x00);           // lock the F18A

   }
}
