/* console_display_unblank.c
   This method unblanks the display identically to how the ROM-based kscan does. It's used for external keyboards that
   will not use kscan's methods
   change log:
   04/30/2025 initial version
*/

#include <vdp.h>
#include <console_private.h>

void console_display_unblank () {

   // reset the timeout
   VDP_SCREEN_TIMEOUT = 0x0000;

   // unblank the screen
   VDP_SET_REGISTER (VDP_REG_MODE1, VDP_REG1_KSCAN_MIRROR); 
}
