/* console_font_dump.c
   This method writes all font data to the specified file. Each font definition is written first
   with the ascii value followed by the hexidecimal representation.
   change log:
   06/01/2023 initial version
   02/24/2024 modified to use dylib
   12/11/2024 updated for spec change on console_font_get_text
   01/20/2025 updated fputs to dylib
*/

#include <stdio.h>
#include <console.h>
#include <dylib.h>

int console_font_dump (const char *filename) {
   char buf[24];
   char s[24];
   FILE *f;
   int r = -1;

   // open the file
   f = dylib.fopen (filename, "w");
   if (f) {
      // loop through all characters
      for (int i = 0; i < 256; i++) {

         // get the character pattern
         console_font_get_text (i, buf);
         
         // format the text for output
         // to do: update to use fprintf when available
         sprintf (s, "%3d\t%s\n", i, buf);

         // output the character number and pattern
         dylib.fputs (s, f);
      }

      // close the file
      dylib.fclose (f);

      r = 0;
   }

   return r;
}
