/* console_font_get.c
   This method returns the font definition for a character value (ascii).
   change log:
   06/01/2023 initial version
   10/20/2023 modified to use cache values
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
   01/23/2025 use shift instead of multiply
*/

#include <vdp.h>
#include <stdio.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_font_get (int c, unsigned char *pattern) {
   int r = -1;

   if ( (c >= 0) & (c <= 255) & (pattern != NULL) ) {
      vdpmemread (cachex.console.vdp_character_pattern_table + (c << 3), pattern, 8);
      r = 0;
   }

   return r;
}
