/* console_font_get_text.c
   This method returns the hexadecimal representation of the character font in PDT.
   change log:
   06/23/2023 initial version
   12/11/2024 updated to use char rather than unsigned char
*/

#include <console.h>
#include <conversion.h>

int console_font_get_text (int c, char *text_font) {
   int r;
   unsigned char font[8];
   r = console_font_get (c, font);
   if (r == 0) {
      unsigned char *p = (unsigned char *) text_font;
      for (int i = 0; i < 8; i++) {
         *p = i2c (font[i] >> 4);
         p++;
         *p = i2c (font[i] & 0x0f);
         p++;
      }
      *p = 0x00;
   }

   return r;
}
