/* console_font_get_width.c
   This method returns the font width based on the display mode.
   change log:
   11/08/2023 initial version
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
   02/02/2025 added f18a text 80x30 mode
   02/28/2025 removed use of DISPLAY_MODE_F18A_TEXT80x30
*/

#include <console.h>
#include <cache_private.h>

int console_font_get_width () {
   int r;
   switch (cachex.console.mode) {
      case DISPLAY_MODE_STANDARD:
      case DISPLAY_MODE_MULTICOLOR:
      case DISPLAY_MODE_BITMAP:
         r = 8;
         break;
      case DISPLAY_MODE_TEXT:
      case DISPLAY_MODE_F18A_TEXT80:
         r = 6;
         break;
      default:
         r = 0;
         break;
   }

   return r;
}
