/* console_font_load.c
   This method loads fonts from a file, requiring one line per character, each
   first indicating the ascii code and second providing the hexadecimal text
   representation of the font. The representations are loaded into the VDP PDT.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
              added reference to stdlib.h
   02/24/2024 modified to use dylib
   02/27/2024 further updates to use dylib
*/

#include <string.h>
#include <stdlib.h>
#include <console.h>
#include <stdio.h>
#include <dylib.h>

int console_font_load (const char *filename) {

   const char *sep = "\t";

   FILE *f;
   char s[32];
   int c;
   char *p = s;
   int r = -1;

   // open the file
   f = dylib.fopen (filename, "r");
   if (f) {

      while (dylib.fgets (s, sizeof (s), f)) {

         s[dylib.strcspn(s, "\r\n")] = 0;                     // remove CR/LF

         p = dylib.strtok (s, sep);
         // get the character number
         c = atoi (p);
   
         p = dylib.strtok (NULL, sep);
 
         // set the font
         r = console_font_set_text (c, p);
        
         if (r) {
            // bad return, exit and notify
            break;
         }
      }

      // close the file
      dylib.fclose (f);
   }

   return r;
}
