/* console_font_set.c
   This method writes a font to the VDP PDT.
   change log:
   06/23/2023 initial version
   08/11/2023 removed setting of fonts changed flag
   10/20/2023 modified to use cache values
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
   01/23/2025 use shift rather than mpy
*/

#include <vdp.h>
#include <stdio.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <dylib.h>

int console_font_set (int c, const unsigned char *font) {
   int r = -1;

   if ( (c >= 0) & (c <= 255) & (font != NULL)) {
      vdpmemcpy (cachex.console.vdp_character_pattern_table + (c << 3), font, 8);
      r = 0;
   }

   return r;
}
