/* console_font_set_text.c
   This method sets the font in PDT based on a hexadecimal text representation.
   change log:
   06/23/2023 initial version
   08/16/2023 removed test for input text been null
*/

#include <console.h>
#include <conversion.h>

int console_font_set_text (int c, const char *text_font) {

   int r = -1;
   unsigned char font[8];
   unsigned char *p = (unsigned char *) text_font;

   for (int i = 0; i < 8; i++) {
      font[i]  = c2i (*p) << 4;
      p++;
      font[i] += c2i (*p);
      p++;
   }
   r = console_font_set (c, font);

   return r;
}
