/* console_get_key.c
   This method simply wraps the kscan(5) call.
   change log:
   06/23/2023 initial version
   09/29/2023 added call to the sequencer
   05/15/2025 added external keyboard support
   06/05/2025 added signal calling for Ctrl-C
   06/09/2025 send the signal after ctrl-c key is lifted
*/

#include <kscan.h>
#include <console.h>
#include <sequencer_private.h>
#include <cache_private.h>
#include <keyboard_private.h>
#include <vdp.h>

int console_get_key_value = 0xff;

int console_get_key () {
   sequencer_update ();                                  // run the sequencer once

   if (cachex.have_external_keyboard) {                  // select from the external keyboard if available, or if not use the console keyboard
      int extkb_key;                                     // external keyboard key
      while ((extkb_key = keyboard_get ()) != 0) {       // process all reads from the keyboard until no key events are left. this is unfortunately a little time 
                                                         // consuming.
         if (extkb_key > 0) {                            // if the key is positive, then this is a new key press
            if (extkb_key == 3) {
               raise (SIGINT);
            } else {
               console_get_key_value = extkb_key;        // capture this as the key to be reported by this method
            }
         } else {                                        // otherwise, 
            if (-extkb_key == console_get_key_value) {   // if the key reported (negative, meaning key is now up) and is the same cached by this method, then
               console_get_key_value = 0xff;             // set the key to the default of no key pressed by the TI99 kscan() standard
            }                                            // note that it is common to type with key_down, key_down, key_up, key_up, as well as in fast paced games.
         }                                               // thus it is important to confirm the key_up event is the same as the last key_down, otherwise the rising of the
      }                                                  // first key will eliminate the holding of the second key, which would be bad.
   } else {
      console_get_key_value = kscan (5);                 // using the console keyboard, so just capture kscan ()
      if (console_get_key_value == 131) {                // 131 = ctrl-c
         while ((console_get_key_value = kscan (5)) != 0xff) { // hold until user stops pressing, so signal handler doesn't fire multiple times
            sequencer_update ();
         }
         raise (SIGINT);                                 // send signal SIGINT
      }
   }

   return console_get_key_value;                         // return the value
}
