/* console_init.c
   This method initializes the console package.
   change log:
   06/23/2023 initial version
   08/11/2023 modified to load fonts at system initialization based on cache values
   08/11/2023 modified to use cache values for mode
   08/11/2023 modified to add atexit method
   08/11/2023 moved extern reference to wd to private include file
   08/24/2023 updated to set text colors
   10/20/2023 modified to use cache values
   10/21/2023 removed multiple window references
   10/21/2023 updated to only initialize if not previously initialized
   11/08/2023 added clearing the screen
   02/10/2024 removed test for whether the cache is already initialized
              minor cleanup
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
   02/28/2025 added default rows for call to console_display_set_mode
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>

void console_init () {

   console_display_set_mode (DISPLAY_MODE_TEXT, DISPLAY_ROWS_DEFAULT); // set the display mode

   console_cls ();                                                     // clear the screen

   console_text_set_default_color ();                                  // set the default text color

   if (cachex.console.mode == DISPLAY_MODE_STANDARD) {                 // set the colors for standard mode if in standard mode
      console_standard_set_all_colors 
         (cachex.console.vdp_screen_color >> 4, 
          cachex.console.vdp_screen_color & 0x0f);
   }  

   console_fonts_load_std ();                                          // load standard fonts
}
