/* console_joystick_read.c
   This method reads the joystick direction, where the joysticks are identified as 0 and 1.
   change log:
   12/25/2024 added header
   12/25/2024 increased jdev by one as the TI console joystick indexing is actually 1 and 2.
*/

#include <console.h>

void console_joystick_read (int jdev, int *y, int *x) {
   unsigned int result;

   // add one to the jdev as the joystick devices are identified as 1 and 2 by the console
   jdev++;

   // read the joystick lines (column 6 or 7, (5 added to unit))
   __asm__("li r12,>0024\n\tai %1,5\n\tswpb %1\n\tldcr %1,3\n\tsrc r12,7\n\tli r12,>0006\n\tclr %0\n\tstcr %0,8" : "=r"(result) : "r"(jdev) : "r12");

   *y = 0;
   *x = 0;

   if ((result & 0x0200) == 0) *x = JOYSTICK_LEFT;
   if ((result & 0x0400) == 0) *x = JOYSTICK_RIGHT;
   if ((result & 0x0800) == 0) *y = JOYSTICK_DOWN;
   if ((result & 0x1000) == 0) *y = JOYSTICK_UP; 
}
