/* console_prepare_bottom_row.c
   This method prepares the bottom row for use by first clearing it and then setting the write position to it
   change log:
   10/20/2023 initial version
   02/16/2024 simplified the method
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
*/

#include <console_private.h>
#include <cache_private.h>
#include <string.h>
#include <vdp.h>
#include <dylib.h>

void console_prepare_bottom_row () {

    cachex.console.vdp_text_addr_current =                                          // set to the bottom row of the screen
       cachex.console.vdp_text_addr_scroll_reqd - cachex.console.screen_width;

    vdpmemset (cachex.console.vdp_text_addr_current, 32, cachex.console.screen_width);
}
