/* console_read_raw_char.c
   This method reads a value from the screen.
   change log:
   02/24/2024 modified to use cache
              added header
   01/22/2025 performance improvements
*/

#include <console.h>
#include <cache_private.h>
#include <vdp.h>

int console_read_raw_char (int y, int x) {
   char c[2];
   vdpmemread (cachex.console.vdp_screen_image_table + y * cachex.console.screen_width + x, (unsigned char *) c, 1);
   return c[0];
}
