/* console_scroll_one.c
   This method scrolls the screen by one row
   change log:
   10/20/2023 initial version
   12/10/2023 changed reference to math.h
   02/14/2024 updated for atomic operation screen scrolling (swapping frame buffers)
   02/16/2024 modified to return the offset of the screen addresses as a result of the scroll
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
   02/08/2025 added GPU-based scrolling
   02/13/2025 initial integration of single parameterized GPU scroll method
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <vdp.h>
#include <math.h>
#include <dylib.h>
#include <conversion.h>

int console_scroll_one () {

   unsigned int tgt_addr = cachex.console.vdp_screen_image_table;
   int offset_addr       = 0;

   int r;

/*
   switch (cachex.console.mode) {
      case DISPLAY_MODE_STANDARD:
         r = gpu_execute (GPU_SCROLL_TEXT_32_X_24);
         break;
      case DISPLAY_MODE_TEXT:
         r = gpu_execute (GPU_SCROLL_TEXT_40_X_24);
         break;
      case DISPLAY_MODE_F18A_TEXT80:
         r = gpu_execute (GPU_SCROLL_TEXT_80_X_24);
         break;
      case DISPLAY_MODE_F18A_TEXT80x30:
         r = gpu_execute (GPU_SCROLL_TEXT_80_X_30);
         break;
      default:
         r = 1;
         break;
   }
*/
   r = gpu_execute (GPU_SCROLL);

   if (r) {

      unsigned int n_remaining = (cachex.console.screen_height - 1) * cachex.console.screen_width;
      unsigned int index       = 0;
      unsigned char buf[256];
      unsigned int n_this_copy;
   
      while (n_remaining) {
         n_this_copy = min (n_remaining, sizeof (buf));
         vdpmemread (cachex.console.vdp_screen_image_table + index + cachex.console.screen_width, buf, n_this_copy);
         vdpmemcpy (tgt_addr + index, buf, n_this_copy);
         index       += n_this_copy;
         n_remaining -= n_this_copy;
      }

      console_prepare_bottom_row ();

   } else {
      cachex.console.vdp_text_addr_current =                                          // set to the bottom row of the screen
         cachex.console.vdp_text_addr_scroll_reqd - cachex.console.screen_width;
   }

   return offset_addr;
}
