/* console_sprite_coincidence.c
   This method performs coincidence detection between two sprites
   change log:
   09/10/2023 initial version
   10/08/2023 corrected spelling of method name
   10/19/2023 corrected misspelling of method name
   06/12/2025 added sensitivity parameter
*/

#include <console_private.h>
#include <console.h>

bool console_sprite_coincidence (int sprite_index_1, int sprite_index_2, int sensitivity) {
   bool r;
   r = ((sprite_info.sprite[sprite_index_1].pos_x >= sprite_info.sprite[sprite_index_2].pos_x &&
         sprite_info.sprite[sprite_index_1].pos_x <= sprite_info.sprite[sprite_index_2].pos_x + sensitivity) ||
        (sprite_info.sprite[sprite_index_1].pos_x + sensitivity >= sprite_info.sprite[sprite_index_2].pos_x &&
         sprite_info.sprite[sprite_index_1].pos_x + sensitivity <= sprite_info.sprite[sprite_index_2].pos_x + sensitivity)) &&
       ((sprite_info.sprite[sprite_index_1].pos_y >= sprite_info.sprite[sprite_index_2].pos_y &&
         sprite_info.sprite[sprite_index_1].pos_y <= sprite_info.sprite[sprite_index_2].pos_y + sensitivity) ||
        (sprite_info.sprite[sprite_index_1].pos_y + sensitivity >= sprite_info.sprite[sprite_index_2].pos_y &&
         sprite_info.sprite[sprite_index_1].pos_y + sensitivity <= sprite_info.sprite[sprite_index_2].pos_y + sensitivity));
   return r;
}  
