/* console_sprite_init.c
   This method initializes sprite data.
   change log:
   09/10/2023 initial version
   09/26/2023 added initialization of the sprite attribute table
              updated to only add to the sequencer one time so that this method can be used to both initialize and reset sprites.
   10/20/2023 modified to use cache values
   10/22/2023 updated for sequencer methods moving from private to public
   11/16/2023 removed adding sprites to the sequencer
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
   02/09/2025 disabled ISR automatic sprite motion
   07/05/2025 dylib adjustments
*/

#include <vdp.h>
#include <string.h>
#include <console_private.h>
#include <sequencer.h>
#include <cache_private.h>
#include <dylib.h>

sprite_info_t sprite_info;

void console_sprite_init () {
   // disable automatic sprite motion by zeroing bit 0x40 of the ISR flag byte at 0x83c2
   unsigned char *isr_flag = (unsigned char *) 0x83c2;
   *isr_flag = *isr_flag & 0xbf;

   memset (&sprite_info, 0x0000, sizeof (sprite_info_t));
   sprite_info.last_used_index   = -1;
   sprite_info.last_motion_index = -1;
   sprite_info.motion_enabled    = true;
   vdpmemset (cachex.console.vdp_sprite_attribute_table, 0x00, 32 * 4);
}
