/* console_sprite_set_magnification.c
   This method sets the sprite magnification on the console.
   change log:
   06/01/2023 initial version
   08/11/2023 modified to use mode from the system cache
   02/24/2024 modified to use cache
   01/11/2025 changed name to console_sprite_set_magnification
              changed references for vdp reg 1 to those in console_private.h
              added support for F18A text and bitmap modes
   01/22/2025 performance improvements
   02/02/2025 added f18a text 80x30 mode
   02/28/2025 removed DISPLAY_MODE_F18A_TEXT80x30
*/

#include <vdp.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_sprite_set_magnification (int sprite_mode) {
   int r;
   int x;
   // this is the size of the sprites, 1, 4, x2
   switch (cachex.console.mode) {
      case DISPLAY_MODE_STANDARD:
         x = DISPLAY_MODE_STANDARD_VDP_REG1;
         r = 0;
         break;
      case DISPLAY_MODE_F18A_TEXT80:
         x = DISPLAY_MODE_F18A_TEXT80_REG1;
         r = 0;
         break;
      case DISPLAY_MODE_BITMAP:
         x = DISPLAY_MODE_BITMAP_REG1;
         r = 0;
         break;
      default:
         r = -1;
         break;
   }

   if (!r) {
      x = x | VDP_MODE1_INT | sprite_mode;
      VDP_SET_REGISTER (VDP_REG_MODE1, x);
   }

   return r;
}
