/* console_sprite_set_pattern.c
   This method writes a font to the VDP PDT.
   change log:
   06/23/2023 initial version
   08/11/2023 removed setting of fonts changed flag
   10/20/2023 modified to use cache values
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <stdio.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <dylib.h>

int console_sprite_set_pattern (int c, const unsigned char *pattern) {
   int r = -1;

   if ( (c >= 0) & (c <= 255) & (pattern != NULL)) {
      vdpmemcpy (cachex.console.vdp_sprite_pattern_table + c * 8, pattern, 8);
      r = 0;
   }

   return r;
}
