/* console_sprite_set_position.c
   This method sets sprite motion.
   change log:
   10/08/2023 initial version
   12/10/2023 changed reference to math.h
*/

#include <math.h>
#include <console_private.h>
#include <console.h>

void console_sprite_set_position (int sprite_index, int y, int x) {
   sprite_info.sprite[sprite_index].pos_y = y;
   sprite_info.sprite[sprite_index].pos_x = x;
   sprite_info.last_used_index            = max (sprite_info.last_used_index, sprite_index);
   console_sprite_set_vdp_vals
      (sprite_index,
       sprite_info.sprite[sprite_index].chardef,
       sprite_info.sprite[sprite_index].color,
       sprite_info.sprite[sprite_index].pos_y,
       sprite_info.sprite[sprite_index].pos_x);
} 
