/* console_sprite_set_values.c
   This method sets all sprite values and is the outward facing API for sprites.
   change log:
   09/10/2023 initial version
   11/16/2023 added call to initialize sprite motion
   12/10/2023 changed reference to math.h
*/

#include <math.h>
#include <console_private.h>
#include <console.h>

void console_sprite_set_values (int sprite_index, int chardef, int color, int pos_y, int pos_x, int vel_y, int vel_x) {
   sprite_info.sprite[sprite_index].chardef = chardef;
   sprite_info.sprite[sprite_index].color   = color;
   sprite_info.sprite[sprite_index].pos_y   = pos_y;
   sprite_info.sprite[sprite_index].pos_x   = pos_x;
   sprite_info.sprite[sprite_index].vel_y   = vel_y;
   sprite_info.sprite[sprite_index].vel_x   = vel_x;
   sprite_info.last_used_index  = max (sprite_info.last_used_index, sprite_index);
   if (vel_y != 0 || vel_x != 0) {
      console_sprite_init_motion ();
      sprite_info.last_motion_index = max (sprite_info.last_motion_index, sprite_index);
   }
   console_sprite_set_vdp_vals
      (sprite_index, 
       sprite_info.sprite[sprite_index].chardef, 
       sprite_info.sprite[sprite_index].color, 
       sprite_info.sprite[sprite_index].pos_y, 
       sprite_info.sprite[sprite_index].pos_x);
}
