/* console_sprite_set_vdp_vals.c
   This method sets sprite attributes in the vdp except velocity.
   change log:
   06/23/2023 initial version
   09/10/2023 changed name from console_sprite_set_vals to console_sprite_set_vdp_vals
   10/20/2023 modified to use cache values
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>

void console_sprite_set_vdp_vals (int n, int ch, int col, int r, int c) {
   unsigned int addr = cachex.console.vdp_sprite_attribute_table + n * 4;
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = r;
   VDPWD = c;
   VDPWD = ch;
   VDPWD = col;
}
