/* console_standard_set_all_colors.c
   This method sets all color sets in standard mode to the same foreground and
   background colors.
   change log:
   06/23/2023 initial version
   08/11/2023 modified to use system cache for display mode
   10/20/2023 modified to use all cache values
   02/24/2024 modified to use cache
   03/01/2024 modified to use dylib
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <dylib.h>

int console_standard_set_all_colors (int fg_color, int bg_color) {
   int r;
   // verify the display mode is valid for this call
   if (cachex.console.mode == DISPLAY_MODE_STANDARD) {
      // write all colors, for 32 character groups
      vdpmemset (cachex.console.vdp_color_table, (fg_color << 4) | bg_color, 32);
      r = 0;
   } else {
      r = -1;
   }
   return r;
}
