/* console_standard_set_char_group_color.c
   This method sets the color for a character group in standard mode.
   change log:
   06/23/2023 initial version
   08/11/2023 modified to use system cache for display mode
   10/20/2023 modified to use all cache values
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_standard_set_char_group_color (int g, int fg_color, int bg_color) {
   int r;
   // verify the display mode is valid for this call
   if (cachex.console.mode == DISPLAY_MODE_STANDARD) {
      // set the color
      unsigned char c = (fg_color << 4) | (bg_color & 0x0f);
      // set the address in the color table
      VDP_SET_ADDRESS_WRITE (cachex.console.vdp_color_table + g);
      // write the color
      VDPWD = c;
      r = 0;
   } else {
      r = -1;
   }
   return r;
}
