/* console_text_set_background_color.c
   This method sets the text mode background color
   change log:
   06/23/2023 initial version
   08/11/2023 modified to use system cache for display mode
   08/24/2023 updated to use vdp_screen_color from cach
   11/01/2023 removed test for display mode
   02/24/2024 modified to use cache
   01/22/2025 performance improvements
*/

#include <console.h>
#include <console_private.h>
#include <cache_private.h>

int console_text_set_background_color (unsigned int color) {
   // set the color
   cachex.console.vdp_screen_color = (cachex.console.vdp_screen_color & 0xf0) | (color & 0x0f);
   // write the color
   console_text_draw_color ();
   return 0;
}
