/* console_text_set_default_color.c
   This method sets the text color to the default colors.
   change log:
   06/23/2023 initial version
   08/23/2023 updated to use vdp_screen_color from cache
   02/24/2024 modified to use cache
   12/27/2024 updated default text color
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>

void console_text_set_default_color () {
   // set the default color value
   cachex.console.vdp_screen_color = (COLOR_DEFAULT_TEXT_FOREGROUND << 4) | COLOR_DEFAULT_TEXT_BACKGROUND;
   // write the color
   console_text_draw_color ();
}
