/* console_write_raw.c
   This method writes to the cache with raw text with no support for control characters.
   change log:
   02/24/2024 added header
              modified to use cache
   03/01/2024 modified to use dylib
   01/17/2025 removed use of dylib as this method is now also located in the kernel
   01/21/2025 updated to use low-level VDP definitions
   01/22/2025 performance improvements
*/

#include <console.h>
#include <cache_private.h>
#include <vdp.h>

void console_write_raw (int y, int x, const char *s, int len) {
   vdpmemcpy (cachex.console.vdp_screen_image_table + y * cachex.console.screen_width + x, (unsigned char *)s, len);
}
