/* dir_copy_centents_recursive.c
   This method copies the contents of a directory recursively.
   change history
   06/02/2025 initial version
   06/03/2025 added support for copy verbosity
*/

#include <utility_private.h>
#include <dirent.h>
#include <dylib.h>

int dir_copy_contents_recursive (batch_t *batch, const char *path_source, const char *path_target) {

   dir_t dir;
   dir.count = 0;

   int r = 1;

   struct dirent *e;
   DIR * d = opendir (path_source);
   if (d) {
      while ((e = readdir (d))) {
         if (e->d_name[0] != '.') {
            dylib.strcpy (dir.entry[dir.count].name, e->d_name);
            dir.entry[dir.count].type = (int) e->d_type;
            dir.count++;
         }
      }
      closedir (d);
      r = 0;
   }

   char path_source_final[40];
   char path_target_final[40];
   for (int i = 0; i < dir.count; i++) {
      dylib.strcpy (path_source_final, path_source);
      dylib.strcat (path_source_final, "/");
      dylib.strcat (path_source_final, dir.entry[i].name);
      if (dir.entry[i].type == 6) {
         dylib.strcpy (path_target_final, path_target);
         dylib.strcat (path_target_final, "/");
         dylib.strcat (path_target_final, dir.entry[i].name);
         batch_mkdir (batch, path_target_final);
         batch_note_double (batch, path_source_final, path_target_final);
         dir_copy_contents_recursive (batch, path_source_final, path_target_final);
      } else {
         dylib.strcpy (path_target_final, path_target);
         dylib.strcat (path_target_final, "/");
         dylib.strcat (path_target_final, dir.entry[i].name);
         batch_file_cp (batch, path_source_final, path_target_final, dir.entry[i].type);
         batch_note_double (batch, path_source_final, path_target_final);
      }
   }

   return r;
}

