/* dir_entry_count.c
   This method returns the number of files in a directory.
   change history
   06/02/2025 initial version
*/

#include <unistd_private.h>
#include <dirent.h>

int dir_entry_count (const char *path) {

   int r = 0;

   struct dirent *e;
   DIR * d = opendir (path);
   if (d) {
      while ((e = readdir (d))) {
         if (e->d_name[0] != '.') {
            r++;
         }
      }
      closedir (d);
   }

   return r;
}
