/* dir_parent_exists.c
   This method returns true if the parent directory of a path exists.
   change history
   06/02/2025 initial version
*/

#include <unistd_private.h>
#include <dylib.h>
#include <dirent.h>
#include <libgen.h>

bool dir_parent_exists (const char *path) {
   char name[40];
   dylib.strcpy (name, dirname ((char *) path));
   bool r = false;
   DIR * d = opendir (name);
   if (d) {
      closedir (d);
      r = true;
   }
   return r;
}
