/* dir_remove_contents_recursively.c
   This method removes a directory and its children recursively.
   change history
   06/02/2025 initial version
   06/03/2025 added user query support and verbosity
*/

#include <utility_private.h>
#include <dirent.h>
#include <dylib.h>

int dir_remove_contents_recursive (batch_t *batch, const char *path_source, bool user_query) {

   dir_t dir;
   dir.count = 0;

   int r = 0;
   int r2 = 0;

   struct dirent *e;
   DIR * d = opendir (path_source);
   if (d) {
      while ((e = readdir (d))) {
         if (e->d_name[0] != '.') {
            dylib.strcpy (dir.entry[dir.count].name, e->d_name);
            dir.entry[dir.count].type = (int) e->d_type;
            dir.count++;
         }
      }
      closedir (d);
   }

   char path_source_final[40];
   for (int i = 0; i < dir.count; i++) {
      dylib.strcpy (path_source_final, path_source);
      dylib.strcat (path_source_final, "/");
      dylib.strcat (path_source_final, dir.entry[i].name);
      if (dir.entry[i].type == 6) {
         if (!user_query || file_examine_directory_query (path_source_final)) {
            r = dir_remove_contents_recursive (batch, path_source_final, user_query);
            if (!r) {
               batch_rmdir (batch, path_source_final);
               batch_note_single (batch, path_source_final);
            }
         } else {
            r = 1;
         }
      } else {
         if (!user_query || file_remove_query (path_source_final)) {
            batch_file_rm (batch, path_source_final);
            batch_note_single (batch, path_source_final);
         } else {
            r = 1;
         }
      }
      r2 += r; // r2 will be positive if any of the user query responses were 'n'
   }

   return r2;
}
