/* dirname.c
   This method returns the directory part of the provided path. Any trailing ‘/’ characters are not counted as part of the 
   directory name.  If path is a null pointer, the empty string, or contains no ‘/’ characters, dirname() returns a pointer 
   to the string ".", signifying the current directory.
   change log:
   11/03/2023 initial version
   11/21/2023 updated to use FILENAME_MAX
   03/01/2024 updated to use dylib
   05/24/2025 corrected special case
*/

#include <libgen.h>
#include <stdio.h>
#include <string.h>
#include <dylib.h>

char *dirname (char *path) {

   static char ipath[FILENAME_MAX];
   int len, i;
   bool found_slash;

   char *r;

   if (path) {
      r = ipath;
      dylib.strcpy (ipath, path);
      len = dylib.strlen (ipath);
      found_slash = false;
      for (i = len - 1; i >= 0; i--) {
         if (ipath[i] == '/') {
            ipath[i]    = 0x00;
            found_slash = true;
         } else {
            break;
         }
      }

/*
      "/WDS1/kok/1.txt////"
      "/bin"
      "/"
      ""
      "bobby"
      "buddy/boy"
      NULL
*/

      if (!dylib.strlen (ipath) && found_slash) {
         r = "/";
      } else {
         found_slash = false;
         len = dylib.strlen (ipath);
         for (i = len - 1; i >= 0; i--) {
            if (ipath[i] == '/') {
               ipath[i]    = 0x00;
               found_slash = true;
               break;
            }
         }
   
         if (!dylib.strlen (ipath)) {
            if (found_slash) {				 
               r = "/";					
            } else {				
               r = "./";		
            }	
         } else {
            if (!found_slash) {
               r = "./";
            }
         }
      }
   } else {
      r = "./";
   }

   return r;
}
