/* dsr_hardware_wait_for_ready.c
   This method waits for the dsr hardware to be ready for use
   change log:
   11/16/2023 initial version
   02/14/2024 simplified method
              updated to address SIT frame swapping by calling the console_write_raw rather than writing to hard-coded 
              VDP address 0x0000
   02/18/2024 updated name with "hardware"
   12/26/2024 modified to use vdpmemcpy rather than console_write_raw
   01/24/2025 removed setting dsr hardware s initialized
*/

#include <stdio.h>
#include <stdio_private.h>
#include <cache_private.h>
#include <vdp.h>

void dsr_hardware_wait_for_ready () {
 
   #define WAIT_TEXT "DSR_HW_WAIT  "

   FILE *f;

   while (! (f = fopen ("/etc/passwd", "r"))) {
      vdpmemcpy (0x0000, (unsigned char *) WAIT_TEXT, sizeof (WAIT_TEXT));   // set the message on the screen at 0, 0
   }
   fclose (f);                                                               // file was opened, so close
}
