/* dsr_path_is_root.c
   This method returns true if the given path is a root DSR path, such as WDS1., DSK1., etc.
   change distory
   05/27/2025 moved from mv.c
*/

#include <unistd_private.h>
#include <dylib.h>
#include <cache_private.h>

bool dsr_path_is_root (const char *path) {
   bool r = false;                                                     // initial result is false
   char path_ti[FILENAME_MAX];                                         // formatted ti DSR path
   dylib.generate_final_path (path_ti, (char *) path, true);           // generate the final ti DSR path
   char *p = strrchr (path_ti, '.');                                   // locate the last dot character, resulting in WDS1.tbd, WDS1, etc.
   *p = 0x00;                                                          // null terminate the path
   for (int i = 0; i < cache.dsr_list.count; i++) {                    // loop through all DSRs
      if (dylib.strcmp (cache.dsr_list.dsr[i].name, path_ti) == 0) {   // test if the path is a DSR name (without the trailing dot)
         r = true;                                                     // it is, set return to true
         break;                                                        // exit the loop
      }
   }
   return r;                                                     // return the result
}
