/* dsrl2_basename_ti.c
   This program provides the basename of a TI formatted path.
   change log:
   05/24/2025 initial version
   05/25/2025 removed use of sprintf
*/ 

#include <dsrl2_private.h>
#include <stdio.h>
#include <string.h>
#include <dylib.h>

void dsrl2_basename_ti (char *basename, const char *ti_path) {
   char *p = strrchr (ti_path, '.') + 1;
   dylib.strcpy (basename, p);
   for (int i = dylib.strlen (basename); i < 10; i++) {
      basename[i] = ' ';
   };
   basename[10] = 0x00;
}
