/* dsrl2_call_method.c     
   This method makes a call to a DSR level 2 method.
   change history
   05/24/2025 initial version
*/

#include <gplws_private.h>
#include <dsrl2_private.h>

void dsrl2_call_method (int crubase, int addr, int link) {

   GPLWSR12 = crubase;
   GPLWSR9  = addr;

   __asm__(
       " lwpi 0x83e0     ; get gplws\n"
       " sbo 0           ; turn on card dsr\n"
       " bl *r9          ; call subroutine\n"
       " nop             ; lvl2 routines never 'skip' request\n"
       " sbz 0           ; turn off card dsr\n"
       " lwpi 0x8300     ; assuming gcc workspace is here\n"
   );
}
