/* dsrl2_collect_info.c
   This method collects the information needed to perform DSR level 2 commands
   change history
   05/24/2025 initial version
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 renamed file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <dsrl2_private.h>
#include <unistd_private.h>
#include <stdio_private.h>
#include <stdio.h>
#include <dylib.h>

int dsrl2_collect_info (const char *path, unsigned int *cru, unsigned char *device, unsigned char *unit, char *dirname, char *basename) {

   int r = 1;

   char ti_path[FILENAME_MAX];
   dylib.generate_final_path (ti_path, (char *) path, false);

   // confirm valid name, the path will have a corresponding cru
   if (file_get_dsr_cru (ti_path)) {

      // calculate the cru, device, unit and directory name for the source file
      *cru    = dsrl2_get_cru (ti_path);
      *device = dsrl2_get_device (ti_path);
      *unit   = dsrl2_get_unit (ti_path);
      dsrl2_dirname_ti (dirname, ti_path);
      dsrl2_basename_ti (basename, ti_path);

      r = 0;
   }
   return r;
}
